% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_ip.R
\name{db_ip}
\alias{db_ip}
\title{Geolocate IP Addresses Through db-ip.com}
\usage{
db_ip(ip_addresses, key)
}
\arguments{
\item{ip_addresses}{a character vector of IP addresses.}

\item{key}{a db-ip.com API key.}
}
\value{
a list of lists, each containing the geolocated values for one IP address.
The variables found depend on the level of access your API key has; see the
DB-IP API documentation on \href{http://db-ip.com}{their website}
for more information.
}
\description{
\code{ip_api} consumes a vector of IP addresses
and geolocates them via \href{https://db-ip.com/}{db-ip.com}.
See `Details` for more information.
}
\details{
\href{http://db-ip.com/}{db-ip.com} provides IP geolocation,
either for free (with a cap of 2,500 requests a day) or in various paid tiers.

To use the service, register there for an API key, and plug that key and the
IP addresses into \code{\link{db_ip}}
}
\examples{
\dontrun{
db_ip(ip_addresses = "173.194.67.1", key = "ThisIsNotARealKey")
}
}
\seealso{
\code{\link{ip_api}} and \code{\link{ip_info}} for other
online geolocation APIs.
}
