% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{add_replace_all_shapes_with_image_request}
\alias{add_replace_all_shapes_with_image_request}
\title{Add a replace all shapes with image request}
\usage{
add_replace_all_shapes_with_image_request(google_slides_request = NULL,
  image_url, replace_method = "CENTER_INSIDE", page_object_ids = NULL,
  text, match_case = TRUE)
}
\arguments{
\item{google_slides_request}{(Optional) A Google Slides Request object which is used to manage requests to the API}

\item{image_url}{The image URL. The image is fetched once at insertion time and a copy is stored for display
inside the presentation. Image must be less than 50mb in size}

\item{replace_method}{The replace method. Accepts 'CENTER_INSIDE' and 'CENTER_CROP'}

\item{page_object_ids}{(Optional) A character vector that contains the list of slide pages that you
wish to enact the change on. It can contain multiple values.}

\item{text}{The text to search for in the shape or table.}

\item{match_case}{Indicates whether the search should respect case}
}
\description{
Add a replace all shapes with image request
}
\examples{
\dontrun{
library(rgoogleslides)
rgoogleslides::authorize()

# Define the presentation slide id (Can be retrieved from the url of the slides)
slides_id <- "<slide-id>"

# Define the internal drive image file to be inserted into slides
file_id <- "<file_id>"

request <- add_replace_all_shapes_with_image_request(image_url = file_id, text = 'aaa')
commit_to_slides(slides_id, request)
}
}
