% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{aligned_page_element_property}
\alias{aligned_page_element_property}
\title{Convenience function to return a page element property that aligns said element}
\usage{
aligned_page_element_property(slide_page_id, slide_page_height = 5143500,
  slide_page_width = 9144000, image_height = NULL,
  image_width = NULL, align = "center")
}
\arguments{
\item{slide_page_id}{The id of the slide page that is to be altered}

\item{slide_page_height}{The slide page height. It is set to default of 9144000}

\item{slide_page_width}{The slide page width. It is set to default of 5143500}

\item{image_height}{Image height in pt. Optional for align mode 'full'}

\item{image_width}{Image width in pt. Optional for align mode 'full'}

\item{align}{Alignment mode that is to be selected. 'center' or 'full' is accepted.}
}
\description{
The Googleslides do not provide convenient ways to align the element. In order to do
the necessary calculation, one has to be do take into account the slide size as well as image size.
}
\details{
The following pointers are thought of when doing the following calculations.
\itemize{
 \item The image is to be scaled without any distortions. No skews etc
 \item The translation coordinates of an image is defined by the top left corner of the image
 \item The following function will not query the Googleslides API to retrieve the page size automatically.
 The user would need to obtain that information and feed it into this function. This is to prevent
 this function from overutilizing the API unnecessarily when utilizing this function
}
}
