% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfmat.R
\name{matchColumnName}
\alias{matchColumnName}
\title{Match a given vector to column names of a data.frame or matrix}
\usage{
matchColumnName(data.frame.cols, reqCols, ignore.case = FALSE)
}
\arguments{
\item{data.frame.cols}{column names of a data.frame. One can also provide a
data.frame, which may however cause worse performance since the data.frame
is copied}

\item{reqCols}{required columns}

\item{ignore.case}{logical, whether the case is considered}
}
\value{
A vector of integers as indices
}
\description{
Match a given vector to column names of a data.frame or matrix
}
\examples{

myTestDf <- data.frame(HBV=1:3, VFB=0:2, BVB=4:6, FCB=2:4)
myFavTeams <- c("HBV", "BVB")
matchColumnName(myTestDf, myFavTeams)
myFavTeamsCase <- c("hbv", "bVb")
matchColumnName(myTestDf, myFavTeamsCase, ignore.case=TRUE)
## NA will be returned in this case if ignore.case is set to FALSE
matchColumnName(myTestDf, myFavTeamsCase, ignore.case=FALSE)

}
