% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccardIndex.R
\name{pairwiseOverlapDistance}
\alias{pairwiseOverlapDistance}
\alias{pairwiseOverlapCoefficient}
\title{Calculate pairwise overlap coefficients between each pair of items in a list}
\usage{
pairwiseOverlapDistance(list)

pairwiseOverlapCoefficient(list)
}
\arguments{
\item{list}{A list}
}
\value{
A symmetric matrix of dimension \code{mxm}, where \code{m} is the
length of the list

\code{pairwiseOverlapDistance} is defined the pairwise overlap distance.
}
\description{
Calculate pairwise overlap coefficients between each pair of items in a list
}
\examples{

myList <- list(first=LETTERS[3:5], second=LETTERS[1:3], third=LETTERS[1:5], fourth=LETTERS[6:10])
pairwiseOverlapCoefficient(myList)
pairwiseOverlapDistance(myList)

poormanPOC <- function(list) {
  sapply(list, function(x) sapply(list, function(y) overlapCoefficient(x,y)))
}
stopifnot(identical(pairwiseOverlapCoefficient(myList), poormanPOC(myList)))

}
