% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.R
\name{as.bin}
\alias{as.bin}
\title{Combine multiple radiocarbon dates within bins}
\usage{
as.bin(
  y,
  er,
  width = 100,
  move.by = c(),
  move.res = 100,
  cc = 1,
  postbomb = FALSE,
  deltaR = 0,
  deltaSTD = 0,
  is.F = FALSE,
  as.F = FALSE,
  thiscurve = NULL,
  yrsteps = 1,
  threshold = 0.001,
  normal = TRUE,
  t.a = 3,
  t.b = 4,
  BCAD = FALSE,
  cc.dir = NULL,
  age.lim = c(),
  age.lab = c(),
  d.lim = c(),
  calib.col = rgb(0, 0, 0, 0.2),
  bin.col = rgb(0, 0, 1, 0.5),
  bin.height = 4,
  talk = TRUE,
  prob = 0.95,
  roundby = 0,
  bty = "n"
)
}
\arguments{
\item{y}{The set of radiocarbon dates to be tested}

\item{er}{The lab errors of the radiocarbon dates}

\item{width}{The bin width to apply. Narrower bins will result in fewer dates fitting those bins, but in more detailed bin width histograms.}

\item{move.by}{Step size by which the window moves. Left empty by default, and then the moves are set by the parameter move.res.}

\item{move.res}{The amount of steps taken to make the histogram. Defaults to \code{move.res=100} - a compromise between detail obtained and calculation speed.}

\item{cc}{Calibration curve to use. Defaults to IntCal20 (\code{cc=1}).}

\item{postbomb}{Whether or not to use a postbomb curve. Required for negative radiocarbon ages.}

\item{deltaR}{Age offset (e.g. for marine samples).}

\item{deltaSTD}{Uncertainty of the age offset (1 standard deviation).}

\item{is.F}{Set this to TRUE if the provided age and error are in the F14C realm.}

\item{as.F}{Whether or not to calculate ages in the F14C realm. Defaults to \code{as.F=FALSE}, which uses the C14 realm.}

\item{thiscurve}{As an alternative to providing cc and/or postbomb, the data of a specific curve can be provided (3 columns: cal BP, C14 age, error).}

\item{yrsteps}{Steps to use for interpolation. Defaults to the cal BP steps in the calibration curve}

\item{threshold}{Report only values above a threshold. Defaults to \code{threshold=1e-6}.}

\item{normal}{Use the normal distribution to calibrate dates (default TRUE). The alternative is to use the t model (Christen and Perez 2016).}

\item{t.a}{Value a of the t distribution (defaults to 3).}

\item{t.b}{Value b of the t distribution (defaults to 4).}

\item{BCAD}{Which calendar scale to use. Defaults to cal BP, \code{BCAD=FALSE}.}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="curves"}.}

\item{age.lim}{Limits of the age axis. Calculated automatically by default.}

\item{age.lab}{Label of the age axis. Defaults to cal BP or BC/AD.}

\item{d.lim}{Limits of the depth/vertical axis. Calculated automatically by default.}

\item{calib.col}{The colour of the individual calibrated ages. Defaults to semi-transparent grey.}

\item{bin.col}{The colour of the combined}

\item{bin.height}{The height of the combined distribution}

\item{talk}{Whether or not to report the calculations made. Defaults to \code{talk=TRUE}.}

\item{prob}{Probability range for highest posterior density (hpd) values. Defaults to \code{prob=0.95}.}

\item{roundby}{Rounding of reported years. Defaults to 0 decimals}

\item{bty}{Draw a box around a box of a certain shape. Defaults to \code{bty="n"}.}
}
\value{
The number of dates that fall within the moving bins, for each bin.
}
\description{
Combine all calibrated dates by calculating their product for a range of calendar ages, as if all dates belonged to the same (unknown) calendar age bin.
}
\details{
This calculates the amount of calibrated dates that fall within a specific bin, and calculates these bins as moving windows over the range of calendar ages to which the radiocarbon ages calibrate.
}
\examples{
\donttest{
  data(shroud)
  shroudbin <- as.bin(shroud$y, shroud$er, 50, 10) 
  # bins of 50 yr, moving by 10 yr, slow
}
}
\author{
Maarten Blaauw
}
