% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_download.R
\name{get_package_download_bioconductor}
\alias{get_package_download_bioconductor}
\title{Get Bioconductor Package Download Statistics}
\usage{
get_package_download_bioconductor(pkg)
}
\arguments{
\item{pkg}{Character string. The name of a Bioconductor package (e.g. "GenomicRanges").}
}
\value{
A list with three elements:
\describe{
  \item{all_data}{A data.frame of the full cleaned dataset with dates and cumulative counts.}
  \item{total_6_months}{Total downloads in the last 6 complete months.}
  \item{total_download}{Total all-time downloads.}
}
}
\description{
Downloads and processes monthly download statistics for a Bioconductor package
from the Bioconductor package statistics archive. Returns the full history,
the total downloads over the last 6 full months (current month excluded),
and the all-time total downloads.
}
\examples{
\dontrun{
  result <- get_package_download_bioconductor("bioconductorpackage")
  print(result$total_6_months)
  head(result$all_data)
  
#$all_data
#Date Year Month Nb_of_distinct_IPs Nb_of_downloads Cumulative_downloads
#1   2009-01-01 2009   Jan               3341            7053                 7053
#2   2009-02-01 2009   Feb               3229            6681                13734
#3   2009-03-01 2009   Mar               3753            8021                21755
  
  #$total_6_months
  #[1] 547560
  
  #$total_download
  #[1] 7318550
}

}
