% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_assess.R
\name{pkg_assess}
\alias{pkg_assess}
\title{Apply assess_* family of functions to a package reference}
\usage{
pkg_assess(
  x,
  assessments = all_assessments(),
  ...,
  error_handler = assessment_error_empty
)
}
\arguments{
\item{x}{A single \code{\link{pkg_ref}} object or
\code{\link[tibble]{tibble}} of package references to assess}

\item{assessments}{A list of assessment functions to apply to each package
reference. By default, a list of all exported assess_* functions from the
riskmetric package.}

\item{...}{additional arguments unused}

\item{error_handler}{A function, which accepts a single parameter expecting
the raised error, which will be called if any errors occur when attempting
to apply an assessment function.}
}
\value{
A \code{\link[tibble]{tibble}} with one row per package reference and
  a new column per assessment function, with cells of that column as package
  metric objects returned when the assessment was called with the associated
  pacakge reference.
}
\description{
By default, use all \code{assess_*} funtions in the \code{riskmetric}
namespace and produce a \code{\link[tibble]{tibble}} with one column per
assessment applied.
}
\section{Assessment function catalog}{

\describe{
\item{\code{\link{assess_remote_checks}}}{Number of OS flavors that passed/warned/errored on R CMD check}
\item{\code{\link{assess_has_news}}}{number of discovered NEWS files}
\item{\code{\link{assess_last_30_bugs_status}}}{vector indicating whether BugReports status is closed}
\item{\code{\link{assess_export_help}}}{exported objects have documentation}
\item{\code{\link{assess_downloads_1yr}}}{number of downloads in the past year}
\item{\code{\link{assess_has_website}}}{a vector of associated website urls}
\item{\code{\link{assess_has_source_control}}}{a vector of associated source control urls}
\item{\code{\link{assess_license}}}{software is released with an acceptable license}
\item{\code{\link{assess_news_current}}}{NEWS file contains entry for current version number}
\item{\code{\link{assess_covr_coverage}}}{Package unit test coverage}
\item{\code{\link{assess_r_cmd_check}}}{Package check results}
\item{\code{\link{assess_has_maintainer}}}{a vector of associated maintainers}
\item{\code{\link{assess_has_vignettes}}}{number of discovered vignettes files}
\item{\code{\link{assess_has_bug_reports_url}}}{presence of a bug reports url in repository}
}
}

