% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{suppressMatchingConditions}
\alias{suppressMatchingConditions}
\title{Suppress messages and warnings based on one or more regex matches}
\usage{
suppressMatchingConditions(expr, ..., .opts = list(), .envir = parent.frame())
}
\arguments{
\item{expr}{An expression to evaluate}

\item{...}{Named parameters, where the name indicates the class of conditions
to capture and the value is a vector of regular expressions that, when
matched against the respective condition message, should suppress that
condition.}

\item{.opts}{A named list of arguments to pass to \code{grepl}}

\item{.envir}{The environment in which \code{expr} is to be evaluated}
}
\value{
a message printed on console
}
\description{
Suppress messages and warnings based on one or more regex matches
}
\examples{
riskmetric:::suppressMatchingConditions({
    print(paste(letters[1:3], collapse = ", "))
    warning(structure(
      list(message = "easy as", call = NULL),
      class = c("custom_warning", "warning", "condition")))
    message(paste(1:3, collapse = ", "))
    message("simple as")
    warning("do re mi")
  },
  message = "\\\\d",
  custom_warning = "as$",
  warning = "\\\\w{2}\\\\s")
}
\keyword{internal}
