% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_freq_prob.R
\name{comp_min_N}
\alias{comp_min_N}
\title{Compute a suitable minimum population size value N.}
\usage{
comp_min_N(prev, sens, spec, min.freq = 1)
}
\arguments{
\item{prev}{The condition's prevalence value \code{\link{prev}}
(i.e., the probability of condition being TRUE).}

\item{sens}{The decision's sensitivity value  \code{\link{sens}}
(i.e., the conditional probability
of a positive decision provided that the condition is TRUE).}

\item{spec}{The specificity value  \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is FALSE).}

\item{min.freq}{The minimum frequency of each combination of
a condition and a decision (i.e., hits, misses, false alarms, and correct rejections).
Default: \code{min.freq = 1}.}
}
\value{
An integer value \code{\link{N}} (as a power of 10).
}
\description{
\code{comp_min_N} is a function that computes a population size value \code{\link{N}} (an integer
as a power of 10) so that the frequencies of the 4 combinations of conditions and decisions
(i.e., the cells of the confusion table, or bottom row of boxes in the natural frequency tree)
reach or exceed a minimum value \code{min.freq} given the basic parameters
\code{prev}, \code{sens}, and \code{spec} (\code{spec = 1 - fart}).
}
\details{
Using this function helps avoiding excessively small decimal values in categories
(esp. true positives, false negatives, false positives, and true negatives)
when expressing combinations of conditions and decisions as natural frequencies.
As values of zero (0) are tolerable, the function only increases  \code{\link{N}}
(in powers of 10) while the current value of any frequency (cell in confusion table or
leaf of tree) is positive but below \code{min.freq}.

Note that \code{\link{comp_freq}} still needs to round to avoid decimal values
in frequencies \code{\link{freq}}.
}
\examples{
comp_min_N(0, 0, 0)  # => 1
comp_min_N(1, 1, 1)  # => 1

comp_min_N(1, 1, 1, min.freq = 10)  # =>  10
comp_min_N(1, 1, 1, min.freq = 99)  # => 100

comp_min_N(.1, .1, .1)        # =>       100 = 10^2
comp_min_N(.001, .1, .1)      # =>    10 000 = 10^4
comp_min_N(.001, .001, .1)    # => 1 000 000 = 10^6
comp_min_N(.001, .001, .001)  # => 1 000 000 = 10^6


}
\seealso{
population size \code{\link{N}};
\code{\link{num}} contains basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes frequencies from probabilities;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes probabilities from probabilities;
\code{\link{comp_freq_freq}} computes current frequency information from (4 essential) frequencies;
\code{\link{comp_freq_prob}} computes current frequency information from (3 essential) probabilities;
\code{\link{comp_prob_freq}} computes current probability information from (4 essential) frequencies;
\code{\link{comp_prob_prob}} computes current probability information from (3 essential) probabilities.

Other functions computing frequencies: \code{\link{comp_freq_freq}},
  \code{\link{comp_freq_prob}}, \code{\link{comp_freq}},
  \code{\link{comp_popu}}, \code{\link{comp_prob_prob}}
}
