% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{dec.neg}
\alias{dec.neg}
\title{Number of individuals for which the decision is negative.}
\format{An object of class \code{numeric} of length 1.}
\usage{
dec.neg
}
\description{
\code{dec.neg} is a frequency that describes the
number of individuals in the current population \code{\link{N}}
for which the decision is negative (i.e., cases not called or not predicted).
}
\details{
Key relationships:

\enumerate{

\item to probabilities:
The frequency of \code{dec.neg} individuals depends on the population size \code{\link{N}} and
the decision's proportion of negative decisions \code{(1 - \link{ppod})} and is split further into two subsets of
\code{\link{cr}} by the negative predictive value \code{\link{NPV}} and
\code{\link{mi}} by the false omission rate \code{\link{FOR} = 1 - \link{NPV}}.

Perspectives:

\enumerate{
  \item by condition:

The frequency \code{\link{dec.neg}} is determined by the population size \code{\link{N}} times
  the proportion of negative decisions \code{(1 - \link{ppod})}:

\code{\link{dec.neg}  =  \link{N} x (1 - \link{ppod})}

\item by decision:

a. The frequency \code{\link{cr}} is determined by \code{\link{dec.neg}} times the negative predictive value \code{\link{NPV}}:

\code{\link{cr}  =  \link{dec.neg} x \link{NPV}}

b. The frequency \code{\link{mi}} is determined by \code{\link{dec.neg}} times the false omission rate \code{\link{FOR} = (1 - \link{NPV})}:

\code{\link{mi}  =  \link{dec.neg} x \link{FOR}  =  \link{dec.neg} x (1 - \link{NPV})}

}

\item to other frequencies:
  In a population of size \code{\link{N}} the following relationships hold:

\itemize{

\item \code{\link{N}  =  \link{cond.true} + \link{cond.false}} (by condition)

\item \code{\link{N}  =  \link{dec.pos} + \link{dec.neg}} (by decision)

\item \code{\link{N} = \link{dec.cor} + \link{dec.err}} (by correspondence of decision to condition)

\item \code{\link{N}  =  \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
  }

}

Current frequency information is computed by
\code{\link{comp_freq}} and contained in a list
\code{\link{freq}}.
}
\examples{
dec.neg <- 1000 * .67   # => sets dec.neg to 67\% of 1000 = 670 cases.
is_freq(dec.neg)        # => TRUE
is_prob(dec.neg)        # => FALSE, as dec.neg is no probability (but ppod, NPV and FOR are)
}
\references{
Consult \href{https://en.wikipedia.org/wiki/Confusion_matrix}{Wikipedia: Confusion matrix} for additional information.
}
\seealso{
\code{\link{is_freq}} verifies frequencies;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other frequencies: \code{\link{N}},
  \code{\link{cond.false}}, \code{\link{cond.true}},
  \code{\link{cr}}, \code{\link{dec.cor}},
  \code{\link{dec.err}}, \code{\link{dec.pos}},
  \code{\link{fa}}, \code{\link{hi}}, \code{\link{mi}}
}
\keyword{datasets}
