% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_prob_prob.R
\name{comp_complement}
\alias{comp_complement}
\title{Compute a probability's complement probability.}
\usage{
comp_complement(prob)
}
\arguments{
\item{prob}{A numeric probability value
(in range from 0 to 1).}
}
\value{
A numeric probability value
(in range from 0 to 1).
}
\description{
\code{comp_complement} computes the
probability complement of a
given probability \code{prob}.
}
\details{
The type and range of \code{prob} is
verified with \code{\link{is_prob}}.
}
\examples{
comp_complement(0)    # => 1
comp_complement(1)    # => 0

comp_complement(2)    # => NA + warning (beyond range)
comp_complement("p")  # => NA + warning (non-numeric)


}
\seealso{
\code{\link{is_complement}} verifies numeric complements;
\code{\link{comp_comp_pair}} returns a probability and its complement;
\code{\link{is_prob}} verifies probabilities.

Other functions computing probabilities: \code{\link{comp_FDR}},
  \code{\link{comp_FOR}}, \code{\link{comp_NPV}},
  \code{\link{comp_PPV}}, \code{\link{comp_accu_freq}},
  \code{\link{comp_accu_prob}}, \code{\link{comp_acc}},
  \code{\link{comp_comp_pair}},
  \code{\link{comp_complete_prob_set}},
  \code{\link{comp_err}}, \code{\link{comp_fart}},
  \code{\link{comp_mirt}}, \code{\link{comp_ppod}},
  \code{\link{comp_prob_freq}}, \code{\link{comp_prob}},
  \code{\link{comp_sens}}, \code{\link{comp_spec}}
}
\concept{functions computing probabilities}
