% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_util.R
\name{is_suff_prob_set}
\alias{is_suff_prob_set}
\title{Verify a sufficient set of probability inputs.}
\usage{
is_suff_prob_set(prev, sens = NA, mirt = NA, spec = NA, fart = NA)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{sens} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}
}
\value{
A Boolean value:
\code{TRUE} if the probabilities provided are sufficient,
otherwise \code{FALSE}.
}
\description{
\code{is_suff_prob_set} is a function that
takes 3 to 5 probabilities as inputs and
verifies that they are sufficient to compute
all derived probabilities and combined frequencies
for a population of \code{\link{N}} individuals.
}
\details{
While no alternative input option for frequencies is provided,
specification of the essential probability \code{\link{prev}}
is always necessary.

However, for 2 other essential probabilities there is a choice:

\enumerate{

\item either \code{\link{sens}} or \code{\link{mirt}} is necessary
(as both are complements).

\item either \code{\link{spec}} or \code{\link{fart}} is necessary
(as both are complements).

}

\code{is_suff_prob_set} does not verify the type, range, or
consistency of its arguments. See \code{\link{is_prob}} and
\code{\link{is_complement}} for this purpose.
}
\examples{
# ways to work:
is_suff_prob_set(prev = 1, sens = 1, spec = 1)  # => TRUE
is_suff_prob_set(prev = 1, mirt = 1, spec = 1)  # => TRUE
is_suff_prob_set(prev = 1, sens = 1, fart = 1)  # => TRUE
is_suff_prob_set(prev = 1, mirt = 1, fart = 1)  # => TRUE

# watch out for:
is_suff_prob_set(prev = 1, sens = 2, spec = 3)  # => TRUE, but is_prob is FALSE
is_suff_prob_set(prev = 1, mirt = 2, fart = 4)  # => TRUE, but is_prob is FALSE
is_suff_prob_set(prev = 1, sens = 2, spec = 3, fart = 4)  # => TRUE, but is_prob is FALSE

## ways to fail:
# is_suff_prob_set()                    # => FALSE + warning (prev missing)
# is_suff_prob_set(prev = 1)            # => FALSE + warning (sens or mirt missing)
# is_suff_prob_set(prev = 1, sens = 1)  # => FALSE + warning (spec or fart missing)

}
\seealso{
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{is_valid_prob_set}} verifies the validity of probability inputs;
\code{\link{as_pc}} displays a probability as a percentage;
\code{\link{as_pb}} displays a percentage as probability.

Other verification functions: \code{\link{is_complement}},
  \code{\link{is_extreme_prob_set}}, \code{\link{is_freq}},
  \code{\link{is_perc}}, \code{\link{is_prob}},
  \code{\link{is_valid_prob_pair}},
  \code{\link{is_valid_prob_set}},
  \code{\link{is_valid_prob_triple}}
}
\concept{verification functions}
