% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskyr_class.R
\name{plot.riskyr}
\alias{plot.riskyr}
\title{Plot a riskyr scenario.}
\usage{
\method{plot}{riskyr}(x = NULL, type = "prism", ...)
}
\arguments{
\item{x}{An object of class "riskyr", usually a result of a call to \code{\link{riskyr}}.
Pre-defined \code{\link{scenarios}} are also of type "riskyr".}

\item{type}{The type of plot to be generated.

The following plot types are currently available:

\enumerate{

  \item \code{type = "prism"} or \code{type = "net"} or \code{type = "tree"}:
  Risk information is plotted in a network diagram of frequencies and probabilities (default).
  See \code{\link{plot_prism}} for further options.

  \item \code{type = "tab"} or \code{type = "ftab"}:
  Risk information is plotted as a 2-by-2 frequency or contingency table.
  See \code{\link{plot_tab}} for further options.

  \item \code{type = "area"} or \code{type = "mosaic"}:
  Risk information is plotted as a mosaic plot (scaled area).
  See \code{\link{plot_area}} for further options.

  \item \code{type = "bar"} or \code{type = "fbar"}:
  Risk information is plotted as a bar chart.
  See \code{\link{plot_bar}} for further options.

  \item \code{type = "icons"} or \code{type = "iconarray"}:
  The underlying population is plotted as an array of icons.
  See \code{\link{plot_icons}} for further options.

  \item \code{type = "curve"} or \code{type = "curves"}:
  Draws curves of selected values (including \code{\link{PPV}}, \code{\link{NPV}})
  See \code{\link{plot_curve}} for further options.

  \item \code{type = "plane"} or \code{type = "planes"}:
  Draws a 3D-plane of selected values (e.g., predictive values \code{\link{PPV}} or \code{\link{NPV}})
  See \code{\link{plot_plane}} for further options.

}}

\item{...}{Additional parameters to be passed to the underlying plotting functions.}
}
\description{
\code{plot.riskyr} is a method that allows to generate
different plot types from a \code{"riskyr"} object.
}
\details{
\code{plot.riskyr} also uses the text settings
specified in the "riskyr" object.
}
\examples{
# Select a scenario (from list of scenarios):
s1 <- scenarios$n1  # select scenario 1 from scenarios
plot(s1)  # default plot (type = "prism")

# Plot types currently available:
plot(s1, type = "prism")                # prism/network diagram (default)
plot(s1, type = "tree", by = "cd")      # tree diagram (only 1 perspective)
plot(s1, type = "area")                 # area/mosaic plot
plot(s1, type = "tab")                  # 2x2 frequency/contingency table
plot(s1, type = "bar", dir = 2)         # bar plot
plot(s1, type = "icons")                # icon array
plot(s1, type = "curve", what = "all")  # curves as fn. of prev
plot(s1, type = "plane", what = "NPV")  # plane as function of sens & spec
plot(s1, type = "default")              # unknown type: use default plot

}
\seealso{
\code{\link{riskyr}} initializes a \code{riskyr} scenario.

Other visualization functions: \code{\link{plot_area}},
  \code{\link{plot_bar}}, \code{\link{plot_curve}},
  \code{\link{plot_fnet}}, \code{\link{plot_icons}},
  \code{\link{plot_mosaic}}, \code{\link{plot_plane}},
  \code{\link{plot_prism}}, \code{\link{plot_tab}},
  \code{\link{plot_tree}}

Other riskyr scenario functions: \code{\link{read_popu}},
  \code{\link{riskyr}}, \code{\link{summary.riskyr}}
}
\concept{riskyr scenario functions}
\concept{visualization functions}
