% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kriging.R
\name{Predict.Kriging}
\alias{Predict.Kriging}
\title{Kriging Prediction}
\usage{
Predict.Kriging(kriging, X)
}
\arguments{
\item{kriging}{a kriging class object}

\item{X}{a matrix for the new input (features) to perform predictions}
}
\value{
\item{mean}{kriging mean computed at the new input}
\item{sd}{kriging standard computed at the new input}
}
\description{
This function gives prediction and uncertainty quantification of the kriging model on a new input.
}
\examples{
# one dimensional example 
f <- function(x) {
  x <- 0.5 + 2*x
  y <- sin(10*pi*x)/(2*x) + (x-1)^4
  return (y)
}

set.seed(1234)
# train set
n <- 30
p <- 1
X <- matrix(runif(n),ncol=p)
y <- apply(X, 1, f)
newX <- matrix(seq(0,1,length=1001), ncol=p)

kriging <- Fit.Kriging(X, y, interpolation=TRUE, fit=TRUE, model="OK",
                       kernel.parameters=list(type="Gaussian"))
pred <- Predict.Kriging(kriging, newX)
plot(newX, f(newX), "l")
points(X, y, pch=16, col="blue")
lines(newX, pred$mean, col="red", lty=2)
lines(newX, pred$mean-2*pred$sd, col="red", lty=3)
lines(newX, pred$mean+2*pred$sd, col="red", lty=3)

}
\references{
Joseph, V. R. (2006). \emph{Limit kriging}. Technometrics, 48(4), 458-466.

Joseph, V. R. (2024). Rational Kriging. \emph{Journal of the American Statistical Association}.

Rasmussen, C. E. & Williams, C. K. (2006). \emph{Gaussian Processes for Machine Learning}. The MIT Press.

Santner, T. J., Williams, B. J., Notz, W. I., & Williams, B. J. (2003). \emph{The design and analysis of computer experiments (Vol. 1)}. New York: Springer.
}
\seealso{
\link{Fit.Kriging}.
}
\author{
Chaofan Huang and V. Roshan Joseph
}
