% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{is_copyable}
\alias{is_copyable}
\title{Is an object copyable?}
\usage{
is_copyable(x)
}
\arguments{
\item{x}{An object to test.}
}
\description{
When an object is modified, R generally copies it (sometimes
lazily) to enforce \href{https://en.wikipedia.org/wiki/Value_semantics}{value semantics}.
However, some internal types are uncopyable. If you try to copy
them, either with \code{<-} or by argument passing, you actually create
references to the original object rather than actual
copies. Modifying these references can thus have far reaching side
effects.
}
\examples{
# Let's add attributes with structure() to uncopyable types. Since
# they are not copied, the attributes are changed in place:
env <- env()
structure(env, foo = "bar")
env

# These objects that can only be changed with side effect are not
# copyable:
is_copyable(env)

structure(base::list, foo = "bar")
str(base::list)
}
\keyword{internal}
