% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-entrace.R
\name{global_entrace}
\alias{global_entrace}
\title{Entrace unexpected errors}
\usage{
global_entrace(enable = TRUE, class = c("error", "warning", "message"))
}
\arguments{
\item{enable}{Whether to enable or disable global handling.}

\item{class}{A character vector of one or several classes of
conditions to be entraced.}
}
\description{
\code{global_entrace()} enriches base errors with rlang features:
\itemize{
\item They are assigned a backtrace. You can configure whether to
display a backtrace on error with the \link{rlang_backtrace_on_error}
global option.
\item They are recorded in \code{\link[=last_error]{last_error()}}. Calling this function is
another way of inspecting the backtrace.
}

When global entracing is enabled, all errors behave as if they had
been thrown with \code{\link[=abort]{abort()}}, even the ones thrown with
\code{\link[=stop]{stop()}} or from native code.

Set global entracing in your RProfile with:\preformatted{rlang::global_entrace()
}
}
\section{Under the hood}{

On R 4.0 and newer, \code{global_entrace()} installs a global handler
with \code{globalCallingHandlers()}. On older R versions, \code{entrace()} is
set as an \code{option(error = )} handler. The latter method has the
disadvantage that only one handler can be set at a time. This means
that you need to manually switch between \code{entrace()} and other
handlers like \code{\link[=recover]{recover()}}. Also this causes a conflict with IDE
handlers (e.g. in RStudio).
}

