% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuggetKrigingClass.R
\name{as.km.NuggetKriging}
\alias{as.km.NuggetKriging}
\title{Coerce a \code{NuggetKriging} object into the \code{"km"} class of the
\pkg{DiceKriging} package.}
\usage{
\method{as.km}{NuggetKriging}(x, .call = NULL, ...)
}
\arguments{
\item{x}{An object with S3 class \code{"NuggetKriging"}.}

\item{.call}{Force the \code{call} slot to be filled in the
returned \code{km} object.}

\item{...}{Not used.}
}
\value{
An object of having the S4 class \code{"KM"} which extends
    the \code{"km"} class of the \pkg{DiceKriging} package and
    contains an extra \code{NuggetKriging} slot.
}
\description{
Coerce a \code{NuggetKriging} object into the \code{"km"} class of the
\pkg{DiceKriging} package.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + 0.1 * rnorm(nrow(X))

k <- NuggetKriging(y, X, "matern3_2")
print(k)

k_km <- as.km(k)
print(k_km)
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
