% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionItem.R
\name{FunctionItem}
\alias{FunctionItem}
\title{Function Items}
\description{
Create Independent functions (that are
not part of any other items) in a 
MiniZinc model
}
\section{Super class}{
\code{\link[rminizinc:Item]{rminizinc::Item}} -> \code{FunctionItem}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.id}}{name of the function}

\item{\code{.e}}{expression in the function}

\item{\code{.decls}}{parameter declarations}

\item{\code{.ann}}{annotation}

\item{\code{.ti}}{return type of the function}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.id}}{name of the function}

\item{\code{.e}}{expression in the function}

\item{\code{.decls}}{parameter declarations}

\item{\code{.ann}}{annotation}

\item{\code{.ti}}{return type of the function}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FunctionItem$new()}}
\item \href{#method-name}{\code{FunctionItem$name()}}
\item \href{#method-getDecls}{\code{FunctionItem$getDecls()}}
\item \href{#method-getBody}{\code{FunctionItem$getBody()}}
\item \href{#method-getAnn}{\code{FunctionItem$getAnn()}}
\item \href{#method-setDecls}{\code{FunctionItem$setDecls()}}
\item \href{#method-setBody}{\code{FunctionItem$setBody()}}
\item \href{#method-setAnn}{\code{FunctionItem$setAnn()}}
\item \href{#method-rtype}{\code{FunctionItem$rtype()}}
\item \href{#method-c_str}{\code{FunctionItem$c_str()}}
\item \href{#method-getDeleteFlag}{\code{FunctionItem$getDeleteFlag()}}
\item \href{#method-delete}{\code{FunctionItem$delete()}}
\item \href{#method-clone}{\code{FunctionItem$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionItem$new(
  name = NULL,
  decls = NULL,
  rt = NULL,
  ann = NULL,
  body = NULL,
  mzn_str = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name of the function}

\item{\code{decls}}{variable declarations}

\item{\code{rt}}{the return type ("bool par", "bool var" or other)}

\item{\code{ann}}{annotation}

\item{\code{body}}{body of the function}

\item{\code{mzn_str}}{string representation of Function Item}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-name"></a>}}
\if{latex}{\out{\hypertarget{method-name}{}}}
\subsection{Method \code{name()}}{
get the name of the function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionItem$name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDecls"></a>}}
\if{latex}{\out{\hypertarget{method-getDecls}{}}}
\subsection{Method \code{getDecls()}}{
get the list of declarations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionItem$getDecls()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getBody"></a>}}
\if{latex}{\out{\hypertarget{method-getBody}{}}}
\subsection{Method \code{getBody()}}{
get the function body
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionItem$getBody()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getAnn"></a>}}
\if{latex}{\out{\hypertarget{method-getAnn}{}}}
\subsection{Method \code{getAnn()}}{
get the function annotation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionItem$getAnn()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setDecls"></a>}}
\if{latex}{\out{\hypertarget{method-setDecls}{}}}
\subsection{Method \code{setDecls()}}{
set the list of declarations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionItem$setDecls(decls)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{decls}}{list of declarations to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setBody"></a>}}
\if{latex}{\out{\hypertarget{method-setBody}{}}}
\subsection{Method \code{setBody()}}{
set the function body
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionItem$setBody()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{body}}{function expression to set or NULL}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setAnn"></a>}}
\if{latex}{\out{\hypertarget{method-setAnn}{}}}
\subsection{Method \code{setAnn()}}{
set the function annotation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionItem$setAnn()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ann}}{annotation to be set or NULL}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rtype"></a>}}
\if{latex}{\out{\hypertarget{method-rtype}{}}}
\subsection{Method \code{rtype()}}{
get if the function is a test, predicate 
or a function call itself.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionItem$rtype()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c_str"></a>}}
\if{latex}{\out{\hypertarget{method-c_str}{}}}
\subsection{Method \code{c_str()}}{
get the MiniZinc representation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionItem$c_str()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDeleteFlag"></a>}}
\if{latex}{\out{\hypertarget{method-getDeleteFlag}{}}}
\subsection{Method \code{getDeleteFlag()}}{
delete flag for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionItem$getDeleteFlag()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
delete the variable item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionItem$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionItem$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
