% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expression.R
\name{Set}
\alias{Set}
\title{Set}
\description{
Create a set in MiniZinc
}
\examples{
newIntSet = Set$new(val = IntSetVal$new(1,5))
newIntSet$c_str()
newIntSet$setIsv(IntSetVal$new(2,6))
newIntSet$c_str()
newFloatSet = Set$new(val = FloatSetVal$new(1.1,5.1))
newFloatSet$c_str()
newFloatSet$setFsv(FloatSetVal$new(1.2,4.1))
}
\section{Super class}{
\code{\link[rminizinc:Expression]{rminizinc::Expression}} -> \code{Set}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.setVal}}{the value of the set}

\item{\code{.isv}}{the integer range set}

\item{\code{.fsv}}{the float range set}

\item{\code{.et}}{empty set}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.setVal}}{the value of the set}

\item{\code{.isv}}{the integer range set}

\item{\code{.fsv}}{the float range set}

\item{\code{.et}}{empty set}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Set$new()}}
\item \href{#method-getSetVec}{\code{Set$getSetVec()}}
\item \href{#method-setSetVec}{\code{Set$setSetVec()}}
\item \href{#method-isEmpty}{\code{Set$isEmpty()}}
\item \href{#method-makeEmpty}{\code{Set$makeEmpty()}}
\item \href{#method-getIsv}{\code{Set$getIsv()}}
\item \href{#method-setIsv}{\code{Set$setIsv()}}
\item \href{#method-getFsv}{\code{Set$getFsv()}}
\item \href{#method-setFsv}{\code{Set$setFsv()}}
\item \href{#method-c_str}{\code{Set$c_str()}}
\item \href{#method-getDeleteFlag}{\code{Set$getDeleteFlag()}}
\item \href{#method-delete}{\code{Set$delete()}}
\item \href{#method-clone}{\code{Set$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constuctor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$new(val = NULL, empty_set = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{val}}{the set value}

\item{\code{empty_set}}{bool to specify is set is empty(FALSE by default)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSetVec"></a>}}
\if{latex}{\out{\hypertarget{method-getSetVec}{}}}
\subsection{Method \code{getSetVec()}}{
get the set expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$getSetVec()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setSetVec"></a>}}
\if{latex}{\out{\hypertarget{method-setSetVec}{}}}
\subsection{Method \code{setSetVec()}}{
set the set expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$setSetVec(val)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{val}}{list of expressions}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isEmpty"></a>}}
\if{latex}{\out{\hypertarget{method-isEmpty}{}}}
\subsection{Method \code{isEmpty()}}{
is the set empty
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$isEmpty()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-makeEmpty"></a>}}
\if{latex}{\out{\hypertarget{method-makeEmpty}{}}}
\subsection{Method \code{makeEmpty()}}{
make the set empty
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$makeEmpty()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getIsv"></a>}}
\if{latex}{\out{\hypertarget{method-getIsv}{}}}
\subsection{Method \code{getIsv()}}{
return the integer set range
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$getIsv()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setIsv"></a>}}
\if{latex}{\out{\hypertarget{method-setIsv}{}}}
\subsection{Method \code{setIsv()}}{
set the integer set range
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$setIsv(val)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{val}}{integer set range}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getFsv"></a>}}
\if{latex}{\out{\hypertarget{method-getFsv}{}}}
\subsection{Method \code{getFsv()}}{
get the float set range
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$getFsv()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setFsv"></a>}}
\if{latex}{\out{\hypertarget{method-setFsv}{}}}
\subsection{Method \code{setFsv()}}{
set the float set range
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$setFsv(val)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{val}}{float set range}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c_str"></a>}}
\if{latex}{\out{\hypertarget{method-c_str}{}}}
\subsection{Method \code{c_str()}}{
get the MiniZinc representation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$c_str()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDeleteFlag"></a>}}
\if{latex}{\out{\hypertarget{method-getDeleteFlag}{}}}
\subsection{Method \code{getDeleteFlag()}}{
delete flag for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$getDeleteFlag()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
delete the assignment item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
