% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/OSGParse.R
\name{OSGParse}
\alias{OSGParse}
\title{Converts UK National Grid Reference to easting/northing coordinates (epsg:27700).}
\usage{
OSGParse(gridRef)
}
\arguments{
\item{gridRef}{This is a string that expresses the UK Grid Reference.}
}
\value{
vector made of two elements: the easting and northing coordinates.
}
\description{
This function converts an OS reference to easting/northing coordinates (UK National Grid, epsg:27700).
}
\examples{
# single entry
OSGParse("TQ722213")

# multiple entries
OSGParse(c("SN831869","SN829838","SN824853","SN824842","SN826854"))
}
\author{
Claudia Vitolo
}
\references{
This function is based on the following post: http://stackoverflow.com/questions/23017053/how-to-convert-uk-grid-reference-to-latitude-and-longitude-in-r/23023744?noredirect=1#23023744
}

