% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSets.R
\docType{data}
\name{mortality}
\alias{mortality}
\title{Mortality and life expectancy in the EU}
\format{A data frame with 60 observations and 12 variables}
\usage{
data(mortality)
}
\description{
\itemize{
 \item{\code{country }}{country name}
 \item{\code{country2 }}{country name, short version}
 \item{\code{sex }}{gender}
 \item{\code{lifeExpectancy }}{life expectancy}
 \item{\code{infectious }}{certain infectious and parasitic diseases (A00-B99)}
 \item{\code{neoplasms }}{malignant neoplasms (C00-C97)}
 \item{\code{endocrine }}{endocrine nutritional and metabolic diseases (E00-E90)}
 \item{\code{mental }}{mental and behavioural disorders (F00-F99)}
 \item{\code{nervous }}{diseases of the nervous system and the sense organs (G00-H95)}
 \item{\code{circulatory }}{diseases of the circulatory system (I00-I99)}
 \item{\code{respiratory }}{diseases of the respiratory system (J00-J99)}
 \item{\code{digestive }}{diseases of the digestive system (K00-K93)}
}
}
\examples{

data(mortality)
str(mortality)
## totals (mortality)
aggregate(mortality[,5:ncol(mortality)], 
          list(mortality$country2), sum)
}
\author{
Peter Filzmoser, Matthias Templ \email{matthias.templ@tuwien.ac.at}
}
\references{
Eurostat, \url{http://ec.europa.eu/eurostat/data}
}
\keyword{data}

