% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orthbasis.R
\name{orthbasis}
\alias{orthbasis}
\title{Orthonormal basis}
\usage{
orthbasis(D)
}
\arguments{
\item{D}{number of parts (variables)}
}
\value{
the orthonormal basis.
}
\description{
Orthonormal basis from cenLR transformed data to pivotCoord transformated data.
}
\details{
For the chosen balances for \dQuote{pivotCoord}, this is the orthonormal basis
that transfers the data from centered logratio to isometric logratio.
}
\examples{

data(expenditures)
V <- orthbasis(ncol(expenditures))
xcen <- cenLR(expenditures)$x.clr
xi <- as.matrix(xcen) \%*\% V$V
xi
xi2 <- pivotCoord(expenditures)
xi2
}
\seealso{
\code{\link{pivotCoord}}, \code{\link{cenLR}}
}
\author{
Karel Hron, Matthias Templ. Some code lines of this function are a copy 
from function gsi.buildilr from
}
\keyword{manip}
