# 2022-04-04

#' Anxieties
#' 
#' Data set consisting of 8 anxiety variables of 82 music students.
#'
#' @usage anxieties
#'
#' @format A 82 x 8 matrix of type integer:
#' \describe{
#'   \item{MPA}{Music performance anxiety}
#'   \item{GAD}{Generalized anxiety disorder}
#'   \item{SAD}{Social anxiety disorder}
#'   \item{PD}{Panic disorder}
#'   \item{AG}{Agoraphophia}
#'   \item{SP}{Specific phobia}
#'   \item{SEP}{Separation anxiety disorder}
#'   \item{ILL}{Illness anxiety disorder}
#' }
#'
#' @details All variables are numerical scores of self-rating instruments, i.e., 
#' the participants fill out questionnaires.
#' MPA is measured by the Kenny Music Performance Anxiety Inventory (score range 0-240).
#' The other 7 variables are disorder-specific anxieties listed in the DSM-5, measured by standard
#' inventories (score range 0-40).
#'
#'
#' @source The data is taken from:
#' \cr
#' A. Wiedemann, D. Vogel, C. Voss, J. Hoyer (2022):
#' \emph{How does music performance anxiety relate to other anxiety disorders?},
#' Psychology of Music 50(1), pp. 204-217,
#' <doi:10.1177/0305735620988600>.
#' Preprint available at <doi:10.31234/osf.io/cev7u>.
#'
#' @examples
#' cor(anxieties)
#' summary(anxieties)
"anxieties"
