% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/classMethod_generate.r
\name{generate}
\alias{generate}
\title{Code Generator}
\arguments{
\item{lang}{Character string to select the language of the generated source
code. Must be either 'f95' (for Fortran) or 'r' (for R).}

\item{name}{Name for the generated function (character string). It should
  start with a letter, optionally followed by letters, numbers, or
  underscores.}
}
\value{
The generated source code as a string. Must be written to
  disk, e.g. using \code{\link[base]{write}}, prior to compilation.
}
\description{
Translate the ODE-model specification into a function that computes process
rates and the state variables derivatives (either in R or Fortran).
}
\note{
Fortran code requires compilation but typically runs much faster than
  the generated R code (typically by a factor between 2 and 100). The
  generation of R code is recommended for simple demo applications and
  testing only where performance is not an issue.

If generated Fortran code is to be used with the numerical solvers from the
  \code{\link[deSolve]{deSolve-package}} or
  \code{\link[rootSolve]{rootSolve-package}} a wrapper is required. It is
  best created with the non-class method \code{\link{solverInterface}}.
}
\examples{
data(exampleIdentifiers, exampleProcesses, exampleStoichiometry)
model= new("rodeo",
  vars=subset(exampleIdentifiers, type=="v"),
  pars=subset(exampleIdentifiers, type=="p"),
  funs=subset(exampleIdentifiers, type=="f"),
  pros=exampleProcesses, stoi=exampleStoichiometry
)
fortranCode= model$generate(lang="f95")
write(fortranCode, file="")
}
\author{
\email{david.kneis@tu-dresden.de}
}
\seealso{
See other methods of the \code{\link{rodeo-class}}, especially
  \code{\link{compile}} or the non-class method \code{\link{solverInterface}}
  to further process generated Fortran code.
}

