% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/classMethod_plotStoichiometry.r
\name{plotStoichiometry}
\alias{plotStoichiometry}
\title{Plot Qualitative Stoichiometry Matrix}
\arguments{
\item{values}{Named numeric vector specifying the values of all state
variables and parameters. For non-autonomous models, there must also be
an element named 'time'.}

\item{cex}{Character expansion factor.}

\item{colPositive}{Color for positive stoichiometric factors.}

\item{colNegative}{Color for negative stoichiometric factors.}

\item{colGrid}{Color of a grid (can be identical to background color).}
}
\description{
Visualizes the stoichiometry matrix using standard plot methods. The sign
of stoichiometric factors is displayed as upward and downward pointing
triangles, optionally colored.
}
\note{
If the stoichiometric factors are mathematical expressions involving
  function references, these functions must be defined in R (even if the
  numerical computations are based on generated Fortran code).
}
\examples{
data(exampleIdentifiers, exampleProcesses, exampleStoichiometry)
model= new("rodeo",
  vars=subset(exampleIdentifiers, type=="v"),
  pars=subset(exampleIdentifiers, type=="p"),
  funs=subset(exampleIdentifiers, type=="f"),
  pros=exampleProcesses, stoi=exampleStoichiometry
)
c_z_in= function(time) {0.1}
c_do_in= function(time) {8.0}
model$plotStoichiometry(c(s_do_z=2.76, c_z=1, c_do=9.022, time=0))
}
\author{
\email{david.kneis@tu-dresden.de}
}
\seealso{
See other methods of the \code{\link{rodeo-class}} or
  \code{\link{stoichiometry}} for computing the stoichiometric factors only.
  Alternative options for displaying stoichiometry information are described
  in the package vignette.
}

