% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classMethod_generate.r
\name{generate}
\alias{generate}
\title{Code Generator}
\arguments{
\item{lang}{Character string to select the language of the generated source
code. Currently either 'f95' (for Fortran) or 'r' (for R).}

\item{name}{Name for the generated function (character string). It should
start with a letter, optionally followed by letters, numbers, or
underscores.}
}
\value{
The generated source code as a string. Must be written to
  disk, e.g. using \code{\link[base]{write}}, prior to compilation.
}
\description{
This is a low-level method to translate the ODE-model specification into a
function that computes process rates and the state variables derivatives
(either in R or Fortran). You probably want to use the high-level method
\code{\link{compile}} instead, which uses \code{generate} internally.
}
\note{
Details of this low-level method may change in the future.
}
\examples{
data(vars, pars, funs, pros, stoi)
model <- rodeo$new(vars, pars, funs, pros, stoi, dim=c(1))
fortranCode <- model$generate(lang="f95")
\dontrun{
write(fortranCode, file="")
}
}
\author{
\email{david.kneis@tu-dresden.de}
}
\seealso{
See other methods of the \code{\link{rodeo-class}}, especially
  \code{\link{compile}} which internally uses this method.
}

