% Generated by roxygen2 (4.0.1): do not edit by hand
\name{removeAssignmentsUB}
\alias{removeAssignmentsUB}
\title{Remove upper bound of alternative possible assignments}
\usage{
removeAssignmentsUB(problem, ...)
}
\arguments{
\item{problem}{Problem from which preference information will be removed.}

\item{...}{Assignments as two-element vectors and/or integers.
Each argument represents assignment to remove. If  \code{c(i, j)} vector was
provided an assignment of an alternative \emph{a_i}
to at most class \emph{C_j} will be removed. In case where single value \code{i} was
given an assignment of an alternative \emph{a_i} will be removed regardless of class.
If a specific assignment was not found nothing will happen.}
}
\value{
Problem with removed assignment examples.
}
\description{
This function removes upper bounds of possible assignments from
a problem.
}
\examples{
# 4 alternatives, 2 gain criteria, 3 classes, monotonously increasing
# and general marginal value functions
perf <- matrix(c(5, 2, 1, 7, 0.5, 0.9, 0.4, 0.4), ncol = 2)
problem <- buildProblem(perf, 3, FALSE, c('g', 'g'), c(0, 0))

# add assignment examples: alternative 1 at least to class 2
# alternative 2 at least to class 3
problem <- addAssignmentsLB(problem, c(1, 2), c(2, 3))

# and remove the assignments
problem <- removeAssignmentsLB(problem, c(1, 2), 2)
}

