% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowr.R
\name{cbind.fill}
\alias{cbind.fill}
\title{Combine arbitrary data types, filling in missing rows.}
\usage{
cbind.fill(..., fill = NULL)
}
\arguments{
\item{...}{any number of R data objects}

\item{fill}{R object to fill empty rows in columns below the max size.  If unspecified, repeats input rows in the same way as \code{cbind}. Passed to \code{\link{buffer}}.}
}
\description{
Robust alternative to \code{\link{cbind}} that fills missing values and works
on arbitrary data types.  Combines any number of R objects into a single matrix, with each input
corresponding to the greater of 1 or ncol.  \code{cbind} has counterintuitive
results when working with lists, cannot handle certain inputs of differing
length, and does not allow the fill to be specified.
}
\examples{
cbind.fill(c(1,2,3),list(1,2,3),cbind(c(1,2,3)))
cbind.fill(rbind(1:2),rbind(3:4))
df<-data.frame(a=c(1,2,3),b=c(1,2,3))
cbind.fill(c(1,2,3),list(1,2,3),cbind(c('a','b')),'a',df)
cbind.fill(a=c(1,2,3),list(1,2,3),cbind(c('a','b')),'a',df,fill=NA)
}

