## ----, echo = FALSE, message = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(collapse = T, comment = "#>", fig.height = 3, fig.width = 7)
options(width = 200)
library(rplexos, quietly = TRUE)
ggplot2::theme_set(ggplot2::theme_bw())

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
location <- location_solution_rplexos()
location

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
process_folder(location)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
db <- plexos_open(location, "Sc1")

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
query_property(db)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
query_generator(db)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
query_day(db, "Generator", "Generation")

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
query_day(db, "Region", "*")

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(ggplot2, quietly = TRUE)

gen <- query_interval(db, "Generator", "Generation")
ggplot(gen, aes(x = time, y = value, fill = name)) +
  geom_area() +
  labs(x = "Time", y = "Generation (MW)", fill = "Generator")

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
price <- query_interval(db, "Node", "Price")
ggplot(price, aes(x = time, y = value, color = name)) +
  geom_line() +
  labs(x = "Time", y = "Price ($/MW)", color = "Node")

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
price <- query_interval(db, "Line", "Flow")
ggplot(price, aes(x = time, y = value, color = name)) +
  geom_line() +
  labs(x = "Time", y = "Flow (MW)", color = "Generator")

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
gen.time.filter <- query_interval(db, "Generator", "Generation",
                                  time.range = c("2015-03-14 00:00:00", "2015-03-14 12:00:00"))
ggplot(gen.time.filter, aes(x = time, y = value, fill = name)) +
  geom_area() +
  labs(x = "Time", y = "Generation (MW)", fill = "Generator")


## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
gen.gral.filter1 <- query_interval(db, "Generator", "Generation",
                                   filter = list(name = "Baseload"))
ggplot(gen.gral.filter1, aes(x = time, y = value, fill = name)) +
  geom_area() +
  labs(x = "Time", y = "Generation (MW)", fill = "Generator")

gen.gral.filter2 <- query_interval(db, "Generator", "Generation",
                                   filter = list(name = c("Baseload", "Wind")))
ggplot(gen.gral.filter2, aes(x = time, y = value, fill = name)) +
  geom_area() +
  labs(x = "Time", y = "Generation (MW)", fill = "Generator")

## ----, message = FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
location2 <- location_input_rplexos()
location2

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
process_folder(location2)

