% Generated by roxygen2 (4.0.0): do not edit by hand
\name{plos_fulltext}
\alias{plos_fulltext}
\alias{print.plosft}
\title{Get full text xml of PLOS papers given a DOI}
\usage{
plos_fulltext(doi, callopts = list())

\method{print}{plosft}(x, ...)
}
\arguments{
\item{doi}{One or more DOIs}

\item{callopts}{Curl options passed on to httr::GET}

\item{x}{Input, of class plosft}

\item{...}{Further args, ignored}
}
\value{
Character string of XML.
}
\description{
Get full text xml of PLOS papers given a DOI
}
\examples{
\dontrun{
plos_fulltext(doi='10.1371/journal.pone.0086169')
plos_fulltext(c('10.1371/journal.pone.0086169','10.1371/journal.pbio.1001845'))
dois <- searchplos(q = "*:*", fq='doc_type:full', limit=20)$id
out <- plos_fulltext(dois)
out['10.1371/journal.pntd.0001738']
out[1:2]

# Extract text from the XML strings
library("XML")
lapply(out[2:3], function(x){
 tmp <- xmlParse(x)
 xpathApply(tmp, "//abstract", xmlValue)
})

# Make a text corpus
library("tm")
out_parsed <- lapply(out, function(x){
 tmp <- xmlParse(x)
 xpathApply(tmp, "//body", xmlValue)
})
tmcorpus <- Corpus(VectorSource(out_parsed))
(dtm <- DocumentTermMatrix(tmcorpus))
findFreqTerms(dtm, lowfreq = 50)
}
}

