\name{mi_glm}
\alias{mi_glm}
\title{Multiple imputation analysis for the generalized linear model}
\usage{
mi_glm(ice, formula, family=gaussian, offset=NULL, eform=FALSE, cl=0.95, digits=4)
}
\arguments{
\item{ice}{An output object of \code{mice} function in \code{mice} package.}

\item{formula}{An object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{family}{A description of the error distribution and link function to be used in the model.}

\item{offset}{A vector of offset. This can be used to specify an a priori known component to be included in the linear predictor during fitting. This should be NULL or a numeric vector of length equal to the number of cases.}

\item{eform}{A logical value that specify whether the outcome should be transformed by exponential function (default: \code{FALSE})}

\item{cl}{Confidence level for calculating confidence intervals (default: 0.95)}

\item{digits}{Number of decimal places in the output (default: 4).}
}
\value{
Results of the multiple imputation analysis for the generalized linear model. For computing covariance matrix estimate, the ordinary Rubin's rule is adapted to the model variance estimates.
\itemize{
\item \code{coef}: Coefficient estimates; transformed to the exponential scale if \code{eform=TRUE}.
\item \code{SE}: Standard error estimates for \code{coef}.
\item \code{CL}: Lower limits of confidence intervals.
\item \code{CU}: Upper limits of confidence intervals.
\item \code{df}: Degree of freedom for the t-approximation.
\item \code{P-value}: P-values for the coefficient tests.
}
}
\description{
Multiple imputation analysis for the generalized linear model is performed for the imputed datasets generated by \code{mice} function in \code{mice} package. For computing covariance matrix estimate, the ordinary Rubin's rule is adapted to the model variance estimates.}
\references{
Little, R. J., and Rubin, D. B. (2019). \emph{Statistical Analysis with Missing Data}, 3rd edition. New York: Wiley.
}
\examples{
library("mice")

data(exdata03)

exdata03$x2 <- factor(exdata03$x2)
exdata03$x3 <- factor(exdata03$x3)
exdata03$x4 <- factor(exdata03$x4)

ice5 <- mice(exdata03,m=5)
# For illustration. m should be >=100.

mi_glm(ice5, y ~ x1 + x2 + x3 + x4, family=binomial, eform=TRUE)
# Logistic regression analysis
# Coefficient estimates are translated to odds ratio scales

mi_glm(ice5, x1 ~ x2 + x3 + x4, family=gaussian)
# Ordinary least-squares regression analysis with the model variance estimator
}
