% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_opal.R
\name{get_resource_url}
\alias{get_resource_url}
\title{Create a URL using the resource's display name in LMS OPAL}
\usage{
get_resource_url(
  display_name,
  endpoint = NULL,
  api_user = NULL,
  api_password = NULL
)
}
\arguments{
\item{display_name}{A length one character vector to entitle file in OPAL;
file name without extension by default; optional.}

\item{endpoint}{A string of endpoint of LMS Opal; by default it is got from
environment variable \code{QTI_API_ENDPOINT}. To set a global environment
variable, you need to call \code{Sys.setenv(QTI_API_ENDPOINT='xxxxxxxxxxxxxxx')}
or you can put these command into .Renviron.}

\item{api_user}{A character value of the username in the OPAL.}

\item{api_password}{A character value of the password in the OPAL.}
}
\value{
A string value of URL.
}
\description{
Create a URL using the resource's display name in LMS OPAL
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
url <- get_resource_url("my test")
\dontshow{\}) # examplesIf}
}
