% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot.R
\name{rray_dot}
\alias{rray_dot}
\title{Matrix multiplication}
\usage{
rray_dot(x, y)
}
\arguments{
\item{x, y}{Arrays or rrays that are either 1D or 2D.}
}
\value{
The result of the matrix multiplication of \code{x} and \code{y}. See \code{\%*\%} for the
exact details. The common type of \code{x} and \code{y} will be preserved.
}
\description{
\code{rray_dot()} works exactly like the base R function, \code{\%*\%}, but preserves
the rray class where applicable. For the exact details of how 1D objects
are promoted to 2D objects, see \link{\%*\%}.
}
\details{
Due to some peculiarities with how \code{\%*\%} dispatches with S3 objects, calling
\code{\%*\%} directly with an rray will compute the matrix multiplication correctly,
but the class will be lost. \code{rray_dot()} ensures that the rray class is
maintained.
}
\examples{
rray_dot(1:5, 1:5)

rray_dot(rray(1:5), 1:5)

}
