% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-assign.R, R/extract.R
\name{rray_extract<-}
\alias{rray_extract<-}
\alias{rray_extract_assign}
\alias{rray_extract}
\title{Get or set elements of an array by index}
\usage{
rray_extract(x, ...) <- value

rray_extract_assign(x, ..., value)

rray_extract(x, ...)
}
\arguments{
\item{x}{A vector, matrix, array, or rray.}

\item{...}{A specification of indices to extract.
\itemize{
\item Integer-ish indices extract specific elements of dimensions.
\item Logical indices must be length 1, or the length of the dimension you are
subsetting over.
\item Character indices are only allowed if \code{x} has names for the corresponding
dimension.
\item \code{NULL} is treated as \code{0}.
}}

\item{value}{The value to assign to the location specified by \code{...}.
Before assignment, \code{value} is cast to the type and dimension of \code{x} after
extracting elements with \code{...}.}
}
\value{
A 1D vector of elements extracted from \code{x}.
}
\description{
\code{rray_extract()} is the counterpart to \code{\link[=rray_yank]{rray_yank()}}. It extracts elements
from an array \emph{by index}. It \emph{always} drops dimensions
(unlike \code{\link[=rray_subset]{rray_subset()}}), and a 1D object is always returned.
}
\details{
Like \code{[[}, \code{rray_extract()} will \emph{never} keep dimension names.

\code{rray_extract()} works with base R objects as well.

\code{rray_extract()} is similar to the traditional behavior of
\code{x[[i, j, ...]]}, but allows each subscript to have length >1.
}
\examples{
x <- rray(1:16, c(2, 4, 2), dim_names = list(c("r1", "r2"), NULL, NULL))

# Extract the first row and flatten it
rray_extract(x, 1)

# Extract the first row and first two columns
rray_extract(x, 1, 1:2)

# You can assign directly to these elements
rray_extract(x, 1, 1:2) <- NA
x

}
\seealso{
Other rray subsetters: \code{\link{rray_slice<-}},
  \code{\link{rray_subset<-}}, \code{\link{rray_yank<-}}
}
\concept{rray subsetters}
