% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squeeze.R
\name{rray_squeeze}
\alias{rray_squeeze}
\title{Squeeze an rray}
\usage{
rray_squeeze(x, axes = NULL)
}
\arguments{
\item{x}{A vector, matrix, array or rray.}

\item{axes}{An integer vector specifying the size 1 dimensions to drop. If
\code{NULL}, all size 1 dimensions are dropped.}
}
\value{
\code{x} with the \code{axes} dropped, if possible.
}
\description{
\code{rray_squeeze()} is conceptually similar to \code{\link[base:drop]{base::drop()}}, but it allows
for the specification of specific dimensions to squeeze.
}
\details{
The dimension name handling of \code{rray_squeeze()} is essentially identical to
\code{drop()}, but some explanation is always helpful:
\itemize{
\item Dimension names are removed from the axes that are squeezed. So squeezing
a \code{(2, 1, 2)} object results in a \code{(2, 2)} object using the dimension names
from the original first and third dimensions.
\item When all dimensions are squeezed, as in the case of \code{(1, 1, 1)}, then
the first dimension names that are found are the ones that are used in the
\code{(1)} result.
}
}
\examples{
# (10, 1) -> (10)
x <- rray(1:10, c(10, 1))
rray_squeeze(x)

# Multiple squeezed dimensions
# (10, 1, 1) -> (10)
y <- rray_reshape(x, c(10, 1, 1))
rray_squeeze(y)

# Use `axes` to specify dimensions to drop
# (10, 1, 1) -> drop 2 -> (10, 1)
rray_squeeze(y, axes = 2)

# Dimension names are kept here
# (10, 1) -> (10)
x <- rray_set_row_names(x, letters[1:10])
rray_squeeze(x)

# And they are kept here
# (1, 10) -> (10)
rray_squeeze(t(x))

}
