% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_assessment.R
\name{rl_assessment_list}
\alias{rl_assessment_list}
\title{Retrieve a list of assessments}
\usage{
rl_assessment_list(ids, key = NULL, wait_time = 0.5, quiet = FALSE, ...)
}
\arguments{
\item{ids}{(integer) A vector of unique identifiers of the assessments.}

\item{key}{(character) An IUCN API token. See \code{\link[=rl_use_iucn]{rl_use_iucn()}}.}

\item{wait_time}{(numeric) The number of seconds to wait between queries. The
default is 0.5 seconds, which is recommended by IUCN to avoid timeouts.}

\item{quiet}{(logical) If \code{TRUE}, suppresses the progress bar.}

\item{...}{Includes the following arguments related to the wait time between
request retries if a "Too Many Requests" error is received from the API
(see \link[crul:HttpClient]{HttpClient()$retry()} for more details):
\itemize{
\item \code{pause_base}, \code{pause_cap}, and \code{pause_min}: basis, maximum, and minimum
for calculating wait time for retry
\item \code{times}: the maximum number of times to retry
\item \code{onwait}: a callback function if the request will be retried and a
wait time is being applied
}
Also supports any \link[curl:curl_options]{curl options} passed to the GET
request via \link[crul:HttpClient]{HttpClient}.}
}
\value{
A list with each element representing the response of
\code{\link[=rl_assessment]{rl_assessment()}}.
}
\description{
Get the full details for a list of IUCN Red List assessments. This is a
wrapper for \code{\link[=rl_assessment]{rl_assessment()}} that allows you to retrieve multiple
assessments at once.
}
\examples{
\dontrun{
# Get assessment details for multiple assessments
ex1 <- rl_assessment_list(ids = c(166290968, 136250858))
}
}
