% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refine_operations.R
\name{refine_move_column}
\alias{refine_move_column}
\title{Move a column in OpenRefine project}
\usage{
refine_move_column(
  column,
  index = 0,
  project.name = NULL,
  project.id = NULL,
  verbose = FALSE,
  validate = TRUE,
  ...
)
}
\arguments{
\item{column}{Name of the column to be removed}

\item{index}{Index to which the column should be placed in the project; default is \code{0} to position the new column as the first column in the project}

\item{project.name}{Name of project}

\item{project.id}{Unique identifier for project}

\item{verbose}{Logical specifying whether or not query result should be printed; default is \code{FALSE}}

\item{validate}{Logical as to whether or not the operation should validate parameters against existing data in project; default is \code{TRUE}}

\item{...}{Additional parameters to be inherited by \code{\link{refine_path}}; allows users to specify \code{host} and \code{port} arguments if the OpenRefine instance is running at a location other than \verb{http://127.0.0.1:3333}}
}
\value{
Operates as a side-effect passing operations to the OpenRefine instance. However, if \code{verbose=TRUE} then the function will return an object of the class "response".
}
\description{
This function allows users to move an existing column in an OpenRefine project via an API query to \verb{/command/core/apply-operations} and the \code{core/column-move} operation.
}
\examples{

\dontrun{
fp <- system.file("extdata", "lateformeeting.csv", package = "rrefine")
refine_upload(fp, project.name = "lfm")
refine_move_column("sleephours", index = 0, project.name = "lfm")
}


}
