% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_tips.r
\name{sort_tips}
\alias{sort_tips}
\alias{sort_tips.phylo}
\alias{sort_tips.multiPhylo}
\title{Sort tip labels}
\usage{
sort_tips(x)

\method{sort_tips}{phylo}(x)

\method{sort_tips}{multiPhylo}(x)
}
\arguments{
\item{x}{a tree of class "phylo" or a collection of trees of class "multiPhylo"}
}
\value{
an input tree with sorted tips
}
\description{
Sort tip labels in a tree or a collection of trees.
}
\details{
The \code{rnni} function assumes tip labels in an unambiguous order.
This is due to the internal implementation not having tip labels,
tip/leave are instead identified by the index in the node matrix.
The \code{sort_tips} orders the tip labels and change the node indices
in the node matrix so that the tips for two different trees of the
same taxa have the same node id.
}
\examples{
# generate random trees
# use rcoal(5) instead of rankedPhylo(5)
# as ranked phylo always generate tip.labels
# in the same order.
t1 = ape::rcoal(5) |> rankedPhylo()
t2 = ape::rcoal(5) |> rankedPhylo()
t1s = sort_tips(t1)
t2s = sort_tips(t2)
all(tips(t1s) == tips(t2s))

# for collection of trees:
trees = c(t1, t2)
sort_tips(trees)

}
