% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tips.r
\name{tips}
\alias{tips}
\alias{tips.phylo}
\alias{tips.multiPhylo}
\title{Extract tips from tree}
\usage{
tips(x, ...)

\method{tips}{phylo}(x, ...)

\method{tips}{multiPhylo}(x, all = FALSE, ...)
}
\arguments{
\item{x}{an object of class "phylo" or "multiPhylo"}

\item{...}{arguments to be passed to methods}

\item{all}{\strong{optional} extract tips for all trees, only if \code{x} is "multiPhylo"}
}
\value{
a vector of tip labels, or list of vectors in case of "multiPhylo" with \code{all=TRUE}
}
\description{
Extract tip labels from the object of class "phylo" or "multiPhylo"
}
\details{
This is convenience method, it's purpose is to easily retrieve tip labels of a tree or
a collection of trees with the same tip labels. Due to this, when called on a collection of
trees (an object of class "multiPhylo"), only the first tree of a collection is accessed.
To obtain tip labels from all trees, specify the argument \code{all=TRUE}.
}
\examples{
tree = rankedPhylo(5)
tips(tree)

trees = rankedPhylo(3:7)
# only the first tree is accessed
tips(trees)

# use this to obtain all tip labels
tips(trees, all=TRUE)

}
