% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{group_vfold_cv}
\alias{group_vfold_cv}
\title{Group V-Fold Cross-Validation}
\usage{
group_vfold_cv(data, group = NULL, v = NULL, ...)
}
\arguments{
\item{data}{A data frame.}

\item{group}{A variable in \code{data} (single character or name) used for
grouping observations with the same value to either the analysis or
assessment set within a fold.}

\item{v}{The number of partitions of the data set. If left as \code{NULL}, \code{v}
will be set to the number of unique values in the group.}

\item{...}{Not currently used.}
}
\value{
A tibble with classes \code{group_vfold_cv},
\code{rset}, \code{tbl_df}, \code{tbl}, and \code{data.frame}.
The results include a column for the data split objects and an
identification variable.
}
\description{
Group V-fold cross-validation creates splits of the data based
on some grouping variable (which may have more than a single row
associated with it). The function can create as many splits as
there are unique values of the grouping variable or it can
create a smaller set of splits where more than one value is left
out at a time. A common use of this kind of resampling is when you have
repeated measures of the same subject.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sacramento, package = "modeldata")

set.seed(123)
group_vfold_cv(Sacramento, group = city, v = 5)
\dontshow{\}) # examplesIf}
}
