% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_node_edge_df.R
\name{create_node_edge_df}
\alias{create_node_edge_df}
\title{Create dataframe of node and aggregated edge embeddings}
\usage{
create_node_edge_df(embeddings_data, function_names = c("mean", "median"))
}
\arguments{
\item{embeddings_data}{A list. The output of any of the SETSe embedding functions}

\item{function_names}{A string vector. the names of the aggregation methods to be used}
}
\value{
A dataframe with node names, node force, node elevation and strain and tension aggregated using the named functions.
The strain and tension columns are returned with names in the form "strain_x" where "x" is the name of the function used 
to aggregate. The total number of columns is dependent on the number of aggregation functions.
}
\description{
Aggregates edge strain and tension to node level
}
\details{
Often if can be useful to have edge data at node level, an example of this would be plotting
the node and tension or strain. To do this requires that the edge embeddings are aggregated somehow to node level
and joined to the appropriate node. This function takes as an argument the output of the SETSe embedding functions
and any number of aggregation functions to produce a dataframe that is convenient to use.
}
\examples{

embeddings_data <- biconnected_network \%>\%
prepare_SETSe_continuous(., node_names = "name", force_var = "force") \%>\%
 SETSe_auto(., k = "weight")

out <- create_node_edge_df(embeddings_data, function_names = c("mean", "mode", "sum"))

}
