% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern.simsum.R
\name{pattern.simsum}
\alias{pattern.simsum}
\title{pattern method for simsum objects}
\usage{
\method{pattern}{simsum}(obj, gpars = list(), ...)
}
\arguments{
\item{obj}{An object of class \code{simsum}.}

\item{gpars}{Graphical parameters. Must be a named list, with possible parameters:
\itemize{
\item \code{alpha}, alpha value of each point on the scatterplot;
\item \code{scales}, scale of \code{x} and \code{y} axis of each facet.
It is possible to redefine all the graphical parameters or a subset only; if not specified, sensible default values will be utilised. Good practice would be adding a colorblind-safe palette, e.g. using \code{\link[ggthemes:scale_color_colorblind]{ggthemes::scale_color_colorblind()}}.
}}

\item{...}{Ignored.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object that can be combined with additional \code{geom_*}, \code{scale_*}, \code{theme_*}, etc.
}
\description{
\code{\link[=pattern]{pattern()}} method for objects of class \code{simsum}.
}
\details{
\code{pattern()} requires \code{simsum} and \code{multisimsum} objects top be fit with the \code{x = TRUE} option.
}
\examples{
library(rsimsum)
library(ggplot2)
data("relhaz", package = "rsimsum")
s <- simsum(data = relhaz, estvarname = "theta", true = -0.5, se = "se",
  methodvar = "model", by = c("n", "baseline"), x = TRUE)
pattern(s)
}
