% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat.multisimsum.R
\name{heat.multisimsum}
\alias{heat.multisimsum}
\title{heat method for simsum objects}
\usage{
\method{heat}{multisimsum}(obj, par, sstat, y, target = NULL, text = FALSE,
  gpars = list(), ...)
}
\arguments{
\item{obj}{An object of class \code{simsum}.}

\item{par}{Estimand to plot.}

\item{sstat}{Summary statistic to plot. Possible choices are: \code{nsim}, number of replications without missing estimates / standard errors; \code{thetamean}, average estimated value; \code{thetamedian}, median estimated value; \code{se2mean}, average estimated standard error; \code{se2median}, median estimated standard error; \code{bias}, bias in point estimate; \code{empse}, empirical standard error; \code{mse}, mean squared error; \code{relprec}, percentage gain in precision relative to the reference method; \code{modelse}, model-based standard error; \code{relerror}, relative percentage error in standard error; \code{cover}, coverage of nominal \eqn{(1 - \alpha)}\% CI; \code{bccover}, bias corrected coverage of nominal \eqn{(1 - \alpha)}\% CI; \code{power}, power of \eqn{\alpha}\% level test.}

\item{y}{Factor on the \code{y}-axis of the plot.}

\item{target}{Target value for the summary statistic of interest. If \code{NULL} (the default), the target value is inferred (except for \code{sstat = nsim}).}

\item{text}{Including estimates and Monte Carlo standard errors in the plot? Defaults to \code{FALSE}.}

\item{gpars}{Graphical parameters. Must be a named list, with possible parameters:
\itemize{
\item \code{target.colour}, colour representing the target value;
\item \code{low.colour}, colour representing the lowest value;
\item \code{high.colour}, colour representing the highest value;
\item \code{fmt}, format string passed to \code{\link[base:sprintf]{base::sprintf()}} to format values and Monte Carlo standard errors.
}

It is possible to redefine all the graphical parameters of a subset only; if not specified, sensible default values will be utilised. The default colours are colorblind-friendly.}

\item{...}{Ignored.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object that can be combined with additional \code{geom_*}, \code{scale_*}, \code{theme_*}, etc.
}
\description{
\code{\link[=heat]{heat()}} method for objects of class \code{simsum}.
}
\details{
Coverage, bias corrected coverage, and power will be based on the \eqn{\alpha} defined in the call to \code{simsum}.
}
\examples{
library(rsimsum)
library(ggplot2)
data("relhaz", package = "rsimsum")
s <- simsum(
  data = relhaz, estvarname = "theta", true = -0.5, se = "se",
  methodvar = "model", by = c("n", "baseline")
)
heat(s, sstat = "bias", y = "baseline")
library(rsimsum)
library(ggplot2)
data("frailty", package = "rsimsum")
ms <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50,
   fv = 0.75), estvarname = "b", se = "se", methodvar = "model",
   by = "fv_dist")
heat(ms, sstat = "bias", par = "trt", y = "fv_dist", x = TRUE)
}
