% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eeg.R
\name{bandpass}
\alias{bandpass}
\title{Bandpass Filter Function}
\usage{
bandpass(x, high, low, sRate, order = 5)
}
\arguments{
\item{x}{A numeric vector representing the signal to be filtered.}

\item{high}{The high cutoff frequency for the bandpass filter.}

\item{low}{The low cutoff frequency for the bandpass filter.}

\item{sRate}{The sampling rate of the signal.}

\item{order}{The order of the Butterworth filter, defaulting to 5.}
}
\value{
A numeric vector representing the filtered signal.
}
\description{
This function applies a bandpass filter to a signal. 
It first normalizes the high and low frequencies based on the Nyquist frequency,
then creates a Butterworth filter using the `signal::butter` function,
and finally applies the filter to the signal using `signal::filtfilt`.
}
\examples{
sample_signal <- sin(seq(0, 10, length.out = 1000))
filtered_signal <- bandpass(sample_signal, high = 0.3, low = 0.1, sRate = 100)
}
\references{
If applicable, add references here.
}
\seealso{
\code{\link[signal]{butter}}, \code{\link[signal]{filtfilt}}
}
