% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rslp.R
\name{rslp}
\alias{rslp}
\title{RSLP}
\usage{
rslp(words, steprules = readRDS(system.file("steprules.rds", package =
  "rslp")))
}
\arguments{
\item{words}{vector of words that you want to stem.}

\item{steprules}{as obtained from the function extract_rules. (only define if you are certain about it).
The default is to get the parsed versionof the rules installed with the package.}
}
\description{
Apply the Stemming Algorithm for the Portuguese Language to
vector of words.
}
\examples{
words <- c("balões", "aviões", "avião", "gostou", "gosto", "gostaram")
rslp(words)

}
\references{
V. Orengo, C. Huyck, "A Stemming Algorithmm for the Portuguese Language", SPIRE, 2001, String Processing and Information Retrieval, International Symposium on, String Processing and Information Retrieval, International Symposium on 2001, pp. 0186, doi:10.1109/SPIRE.2001.10024
}

