% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{set_api_url}
\alias{set_api_url}
\title{Set the \code{RSPACE_API_URL} environment variable}
\usage{
set_api_url(rspace_api_url)
}
\arguments{
\item{rspace_api_url}{The RSpace API URL}
}
\value{
A logical indicating if setting the API URL succeeded.
}
\description{
Sets the \code{RSPACE_API_URL} environment variable to the provided RSpace API URL.
The RSpace API URL is likely the URL of your RSpace instance followed by \code{api/v1}.
}
\details{
This will only set the environment variable for the current session,
to set it permanently, add \verb{RSPACE_API_URL=<your_api_url_here>} to your \code{.Renviron} file,
for example, using \code{\link[usethis:edit]{usethis::edit_r_environ()}}.
}
\examples{
\dontrun{
set_api_url("https://leiden.researchspace.com/api/v1")
}
}
