% Generated by roxygen2 (4.0.2): do not edit by hand
\name{peek_top<-}
\alias{peek_top<-}
\title{Assign to/modify the top of an rstack}
\usage{
peek_top(s, ...) <- value
}
\arguments{
\item{s}{rstack to modify the first element of.}

\item{...}{additional arguments to be passed to or from methods (ignored).}

\item{value}{value to assign to the top data element.}
}
\value{
modified rstack.
}
\description{
Allows modification access to the top of a stack.
}
\details{
Runs in \eqn{O(1)} worst case time. Throws an error if the rstack is \code{\link{empty}}. Modifies the element in place (i.e., is not side-effect-free).
}
\examples{
s <- rstack()
s <- insert_top(s, data.frame(a = 1, b = 1))
s <- insert_top(s, data.frame(a = 1, b = 1))

peek_top(s)$a <- 100
print(s)

peek_top(s) <- data.frame(a = 100, b = 100)
}
\seealso{
\code{\link{peek_top}} for accessing the top data element.
}

