% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_delta.R
\name{adapt_delta}
\alias{adapt_delta}
\title{Target average acceptance probability}
\description{
Target average acceptance probability
}
\details{
For the No-U-Turn Sampler (NUTS), the variant of Hamiltonian Monte 
  Carlo used used by \pkg{rstanarm}, \code{adapt_delta} is the target average
  proposal acceptance probability for adaptation. \code{adapt_delta} is 
  ignored if \code{algorithm} is not \code{"sampling"}.
  
  The default value of \code{adapt_delta} is 0.95, except when the prior for 
  the regression coefficients is \code{\link{R2}}, \code{\link{hs}}, or 
  \code{\link{hs_plus}}, in which case the default is 0.99.
  
  In general you should not need to change \code{adapt_delta} unless you see
  a warning message about divergent transitions, in which case you can
  increase \code{adapt_delta} from the default to a value \emph{closer} to 1
  (e.g. from 0.95 to 0.99, or from 0.99 to 0.999, etc). The step size used by
  the numerical integrator is a function of \code{adapt_delta} in that
  increasing \code{adapt_delta} will result in a smaller step size and fewer
  divergences. Increasing \code{adapt_delta} will typically result in a
  slower sampler, but it will always lead to a more robust sampler.
}
\references{
Stan Development Team. (2016). \emph{Stan Modeling Language Users Guide and
Reference Manual.} \url{http://mc-stan.org/documentation/}
}

