% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanreg-methods.R
\name{stanreg-methods}
\alias{VarCorr}
\alias{VarCorr.stanreg}
\alias{coef.stanreg}
\alias{confint.stanreg}
\alias{fitted.stanreg}
\alias{fixef}
\alias{fixef.stanreg}
\alias{log_lik.stanreg}
\alias{ngrps}
\alias{ngrps.stanreg}
\alias{nobs.stanreg}
\alias{ranef}
\alias{ranef.stanreg}
\alias{residuals.stanreg}
\alias{se.stanreg}
\alias{sigma.stanreg}
\alias{stanreg-methods}
\alias{update.stanreg}
\alias{vcov.stanreg}
\title{Methods for stanreg objects}
\usage{
\method{coef}{stanreg}(object, ...)

\method{confint}{stanreg}(object, parm, level = 0.95, ...)

\method{fitted}{stanreg}(object, ...)

\method{log_lik}{stanreg}(object, ...)

\method{nobs}{stanreg}(object, ...)

\method{residuals}{stanreg}(object, ...)

\method{se}{stanreg}(object, ...)

\method{update}{stanreg}(object, formula., ..., evaluate = TRUE)

\method{vcov}{stanreg}(object, correlation = FALSE, ...)

\method{fixef}{stanreg}(object, ...)

\method{ngrps}{stanreg}(object, ...)

\method{ranef}{stanreg}(object, ...)

\method{sigma}{stanreg}(object, ...)

\method{VarCorr}{stanreg}(x, sigma = 1, rdig = 3)
}
\arguments{
\item{object, x}{A fitted model object returned by one of the
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{...}{Ignored, except by the \code{update} method. See
\code{\link{update}}.}

\item{parm}{For \code{confint}, an optional character vector of parameter
names.}

\item{level}{For \code{confint}, a scalar between \eqn{0} and \eqn{1}
indicating the confidence level to use.}

\item{formula., evaluate}{See \code{\link[stats]{update}}.}

\item{correlation}{For \code{vcov}, if \code{FALSE} (the default) the
covariance matrix is returned. If \code{TRUE}, the correlation matrix is
returned instead.}

\item{sigma, rdig}{Ignored (included for compatibility with
\code{\link[lme4]{VarCorr}}).}
}
\description{
S3 methods for \link[=stanreg-objects]{stanreg} objects. There are also 
several methods (listed in See Also, below) with their own individual help
pages.
}
\details{
Most of these methods are similar to the methods defined for objects
  of class 'lm', 'glm', 'glmer', etc. However there are a few exceptions:
  
\describe{
\item{\code{confint}}{
For models fit using optimization, confidence intervals are returned via a
call to \code{\link[stats]{confint.default}}. If \code{algorithm} is
\code{"sampling"}, \code{"meanfield"}, or \code{"fullrank"}, the
\code{\link{posterior_interval}} function should be used to compute Bayesian
uncertainty intervals.
}

\item{\code{log_lik}}{
For models fit using MCMC only, the \code{log_lik}
function returns the \eqn{S} by \eqn{N} pointwise log-likelihood matrix,
where \eqn{S} is the size of the posterior sample and \eqn{N} is the number
of data points. Note: we use \code{log_lik} rather than defining a
\code{\link[stats]{logLik}} method because (in addition to the conceptual
difference) the documentation for \code{logLik} states that the return value
will be a single number, whereas we return a matrix.
}

\item{\code{residuals}}{
Residuals are \emph{always} of type \code{"response"} (not \code{"deviance"}
residuals or any other type). However, in the case of \code{\link{stan_polr}}
with more than two response categories, the residuals are the difference 
between the latent utility and its linear predictor.
}
\item{\code{coef}}{
Medians are used for point estimates. See the \emph{Point estimates} section
in \code{\link{print.stanreg}} for more details.
}
\item{\code{se}}{
The \code{se} function returns standard errors based on 
\code{\link{mad}}. See the \emph{Uncertainty estimates} section in
\code{\link{print.stanreg}} for more details.
}
}
}
\note{
Because \code{sigma} is not yet included in \pkg{stats}, both 
  \pkg{rstanarm} and \pkg{lme4} export a \code{sigma} generic. If both
  packages are loaded it may be necessary to use \code{rstanarm::sigma} or
  \code{lme4::sigma} (depending on which package is loaded first) in order to
  access the appropriate method.
}
\seealso{
Other S3 methods for stanreg objects, which have separate documentation, 
including \code{\link{as.matrix.stanreg}}, \code{\link{plot.stanreg}}, 
\code{\link{predict.stanreg}}, \code{\link{print.stanreg}}, and
\code{\link{summary.stanreg}}.

\code{\link{posterior_interval}} and \code{\link{posterior_predict}} for 
alternatives to \code{confint} and \code{predict} for models fit using MCMC 
or variational approximation.
}

